//***************************************************************************

// Copyright (C) 2009 Realmac Software Ltd
//
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information of Realmac Software Ltd
// and are protected by copyright law. They may not be disclosed
// to third parties or copied or duplicated in any form, in whole or
// in part, without the prior written consent of Realmac Software Ltd.

// Created by Keith Duncan on 29/04/2009

//***************************************************************************

#import <Cocoa/Cocoa.h>

/*!
	\brief
	You should check if the -draggingSource passed in to your dragging destination via NSDraggingInfo conforms to this protocol before calling any of the methds.
 */
@protocol RMDraggingInfoAnimator <NSObject>

/*!
	\brief
	This method will morph the representation of what the sender dragged out to your image.
	The animation used is currently up to the sender, though it will probably be a scale and fade.
 
	\details
	This method will probably be called by the dragging destination in -draggingEntered: or at an appropriate time in -draggingUpdated:
 */
- (void)animateDraggingRepresentation:(NSImage *)newImage centerPoint:(CGPoint)screenPoint;

/*!
	\brief
	This method tells the sender to revert the representation back to the original format.
	
	\details
	This method will probably be called by the dragging destination in -draggingExited: or at an appropriate time in -draggingUpdated:
 */
- (void)revertDraggingRepresentation;

/*!
	\brief
	Animates the center of the container back to it's original position, accounting for any frame changes since initialisation.
	
	\details
	A drag receiver MUST NOT call this method, the sender will animate the container back to it's origin if it intended |slideBack| to be YES.
 */
- (void)animateContainerToOriginalPosition;

/*!
	\brief
	Animates the center of the container to it's final position, this should place the current representation over where it wil be drawn in the destination.
	
	\details
	A drag sender MUST NOT call this method, the receiver will animate the container if appropriate.
 */
- (void)animateContainerToFinalPosition:(CGPoint)screenPoint;

@end
